-- Jukebox for Source SQL tables
-- version 0.5.4.0

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `jukebox`
--

-- --------------------------------------------------------

--
-- Table structure for table `jb_active_guests`
--

CREATE TABLE IF NOT EXISTS `jb_active_guests` (
  `ip` varchar(15) NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_active_users`
--

CREATE TABLE IF NOT EXISTS `jb_active_users` (
  `username` varchar(30) NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_banned_users`
--

CREATE TABLE IF NOT EXISTS `jb_banned_users` (
  `username` varchar(30) NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_log`
--

CREATE TABLE IF NOT EXISTS `jb_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned NOT NULL,
  `username_id` mediumint(8) unsigned NOT NULL,
  `history_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `jb_log_history`
--

CREATE TABLE IF NOT EXISTS `jb_log_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned NOT NULL,
  `username_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `track_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `joined` smallint(5) unsigned NOT NULL DEFAULT '0',
  `start` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `finish` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `join_time` (`joined`),
  KEY `start` (`start`),
  KEY `finish` (`finish`),
  KEY `user_id` (`user_id`),
  KEY `username_id` (`username_id`),
  KEY `track_id` (`track_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_log_usernames`
--

CREATE TABLE IF NOT EXISTS `jb_log_usernames` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`username`),
  FULLTEXT KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_options`
--

CREATE TABLE IF NOT EXISTS `jb_options` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `steamid` varchar(24) NOT NULL,
  `playall` tinyint(1) NOT NULL DEFAULT '1',
  `volume` tinyint(3) unsigned NOT NULL DEFAULT '80',
  `autoqueue` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `steamid` (`steamid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `jb_streams`
--

CREATE TABLE IF NOT EXISTS `jb_streams` (
  `stream_id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `creator_steam` varchar(24) DEFAULT NULL,
  `creator_name` varchar(255) DEFAULT NULL,
  `now_playing` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `playall` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `volume_shift` tinyint(4) NOT NULL DEFAULT '0',
  `queue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`stream_id`),
  KEY `start_time` (`start_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_stream_tracks`
--

CREATE TABLE IF NOT EXISTS `jb_stream_tracks` (
  `stream_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `track_id` mediumint(8) unsigned DEFAULT NULL,
  `sequence` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`stream_id`,`sequence`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jb_tracks`
--

CREATE TABLE IF NOT EXISTS `jb_tracks` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL,
  `album` varchar(80) NOT NULL,
  `artist` varchar(80) NOT NULL,
  `genre` varchar(40) NOT NULL,
  `track` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `md5` varchar(32) NOT NULL,
  `bitrate` smallint(5) unsigned NOT NULL DEFAULT '0',
  `playtime` float unsigned NOT NULL,
  `added` datetime NOT NULL,
  `uploader` mediumint(9) NOT NULL,
  `playcount` smallint(5) unsigned NOT NULL DEFAULT '0',
  `popularity` float unsigned NOT NULL DEFAULT '0',
  `uploaded` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `metadata` (`title`,`album`,`artist`),
  KEY `popularity` (`popularity`),
  KEY `added` (`added`),
  KEY `genre` (`genre`),
  KEY `uploader` (`uploader`),
  KEY `title` (`title`),
  KEY `album` (`album`),
  KEY `artist` (`artist`),
  KEY `uploaded` (`uploaded`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `jb_users`
--

CREATE TABLE IF NOT EXISTS `jb_users` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL,
  `password` varchar(32) DEFAULT NULL,
  `userid` varchar(32) NOT NULL DEFAULT '',
  `userlevel` tinyint(1) unsigned NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;


-- Add default "admin" account for the website portion
INSERT INTO `jb_users` (`username`, `password`, `userid`, `userlevel`, `email`) VALUES
('admin', '21232f297a57a5a743894a0e4a801fc3', 'e21c0af3bbe824e927c0db61403eb651', 9, 'admin@example.com');