<?php
/**
 * Register.php
 *
 * Displays the registration form if the user needs to sign-up,
 * or lets the user know, if he's already logged in, that he
 * can't register another name.
 *
 * Written by: Jpmaster77 a.k.a. The Grandmaster of C++ (GMC)
 * Last Updated: August 19, 2004
 */
require_once "include/security.php";
require_once "include/login/session.php";

function html_foot() {
	print("</body>\n");
	print("</html>\n");
}

if(!html_head_secure("Jukebox - HTTP post", "OpenBrWindow")) {
	html_foot();
	exit();
}

if(!$session->isAdmin()){
	print("<P>Sorry, only admins may create new accounts.</P>\n");
	print("<P><A HREF=\"index.php\">Return to the Front Page</A></P>\n");
}
/**
 * The user has submitted the registration form and the
 * results have been processed.
 */
else if(isset($_SESSION['regsuccess'])){
   /* Registration was successful */
   if($_SESSION['regsuccess']){
      echo "<h1>Registered!</h1>";
      echo "<p>New account has been created.</p>";
      echo "<table>";
      echo "<tr><th align=\"right\">Username:</th><td align=\"left\">" . $_SESSION['reguname'] . "</td></tr>";
      echo "<tr><th align=\"right\">Password:</th><td align=\"left\">" . $_SESSION['regpass'] . "</td></tr>";
      echo "<tr><th align=\"right\">E-mail:</th><td align=\"left\">" . $_SESSION['regemail'] . "</td></tr>";
      echo "</table>";
   }
   /* Registration failed */
   else{
      echo "<h1>Registration Failed</h1>";
      echo "<p>We're sorry, but an error has occurred and your registration for the username <b>".$_SESSION['reguname']."</b>, "
          ."could not be completed.<br>Please try again at a later time.</p>";
   }
   unset($_SESSION['regsuccess']);
   unset($_SESSION['reguname']);
}
/**
 * The user has not filled out the registration form yet.
 * Below is the page with the sign-up form, the names
 * of the input fields are important and should not
 * be changed.
 */
else{
?>

<h1>Create New User</h1>
<?php
if($form->num_errors > 0){
   echo "<td><font size=\"2\" color=\"#ff0000\">".$form->num_errors." error(s) found</font></td>";
}
?>
<form action="process.php" method="POST">
<table align="left" border="0" cellspacing="0" cellpadding="3">
<tr><td>Username:</td><td><input type="text" name="user" maxlength="30" value="<?php echo $form->value("user"); ?>"></td><td><?php echo $form->error("user"); ?></td></tr>
<tr><td>Password:</td><td><input type="password" name="pass" maxlength="30" value="<?php echo $form->value("pass"); ?>"></td><td><?php echo $form->error("pass"); ?></td></tr>
<tr><td>Email:</td><td><input type="text" name="email" maxlength="50" value="<?php echo $form->value("email"); ?>"></td><td><?php echo $form->error("email"); ?></td></tr>
<tr><td colspan="2" align="right">
<input type="hidden" name="subjoin" value="1">
<input type="submit" value="Create"></td></tr>
<tr><td colspan="2" align="left"><a href="admin.php">Back to Admin Center</a></td></tr>
</table>
</form>

<?php
}

html_foot();
?>