<?php

require_once "login/session.php";
require_once "login/constants.php";
include dirname(__FILE__) . "/../version.php";


/*** login_script()



***/
function login_script() {
	global $form;

	if($form->num_errors > 0){
		echo "<font size=\"2\" color=\"#ff0000\">".$form->num_errors." error(s) found</font>";
	}

	print("<form action=\"process.php\" method=\"POST\">\n");
	print("\t<table align=\"left\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">\n");
	print("\t\t<tr><td>Username:</td><td><input type=\"text\" name=\"user\" maxlength=\"30\" value=\"" . $form->value("user") . "\"></td><td>" . $form->error("user") . "</td></tr>");
	print("\t\t<tr><td>Password:</td><td><input type=\"password\" name=\"pass\" maxlength=\"30\" value=\"" . $form->value("pass") . "\"></td><td>" . $form->error("pass") . "</td></tr>\n");
	print("\t\t<tr><td colspan=\"2\" align=\"left\"><input type=\"checkbox\" name=\"remember\"");
	if($form->value("remember") != "") {
		print(" checked=\"checked\"");
	}
	print(" />\n");
	print("\t\t\t<font size=\"2\">Remember me next time &nbsp;&nbsp;&nbsp;&nbsp;\n");
	print("\t\t\t<input type=\"hidden\" name=\"sublogin\" value=\"1\">\n");
	print("\t\t\t<input type=\"submit\" value=\"Login\"></td></tr>\n");
	print("\t\t<tr><td colspan=\"2\" align=\"left\"><br><font size=\"2\">[<a href=\"forgotpass.php\">Forgot Password?</a>]</font></td><td align=\"right\"></td></tr>\n");
	print("\t</table>\n");
	print("</form>\n\n");

	return NULL;
}


function security_header() {
	global $session, $jb_version;

	$links = array(
			array("Browse", "browse.php", USER_LEVEL),
			array("Add New Tracks", "upload.php", UPLOAD_LEVEL),
			array("My Account", "userinfo.php?user=" . $session->username, USER_LEVEL),
			array("Edit Account", "useredit.php", USER_LEVEL),
			array("Admin Center", "admin.php", ADMIN_LEVEL),
			array("Logout", "process.php", USER_LEVEL)
		);

	$option_count = 0;
	$user_level = $session->userinfo['userlevel'];
	foreach($links as $target) {
		if($user_level >= $target[2]) {
			$option_count++;
		}
	}

	print("<TABLE ALIGN=\"center\">\n");
	print("\t<TR><TD COLSPAN=\"" . $option_count . "\" ALIGN=\"center\">\n");
	print("\t\t<H1>Jukebox for Source</H1>\n");
	print("\t</TD></TR>\n");
	print("\t<TR><TD COLSPAN=\"" . $option_count . "\" ALIGN=\"center\">\n");
	print("\t\t<H2>Streaming Music System</H2>\n");
	print("\t</TD></TR>\n");
	if(isset($jb_version)) {
		print("\t<TR><TD COLSPAN=\"" . $option_count . "\" ALIGN=\"center\">\n");
		print("\t\tVersion ". $jb_version . "\n");
		print("\t</TD></TR>\n");
	}
	print("\t<TR><TD COLSPAN=\"" . $option_count . "\" ALIGN=\"center\">\n");
	print("\t\tWelcome, <B>" . $session->username . "</B>.\n");
	print("\t</TD></TR>\n");
	print("\t<TR>\n");
	foreach($links as $target) {
		if($user_level >= $target[2]) {
			print("\t\t<TD ALIGN=\"center\">\n");
			print("\t\t\t[<A HREF=\"" . $target[1] . "\">" . $target[0] . "</A>]\n");
			print("\t\t</TD>\n");
		}
	}
	print("\t</TR>\n");
	print("</TABLE>\n");

	return NULL;
}


function html_head_secure($title = "") {
	global $session;

	$num_args = func_num_args();
	print ("<HTML>\n<HEAD>\n\t<TITLE>".$site_name." - ".$title."</TITLE>\n");
	if($num_args > 1) {
		for($i = 1; $i < $num_args; $i++) {
			$row = func_get_arg($i);
			if(is_string($row)) {
				print("\t<SCRIPT TYPE=\"text/JavaScript\" SRC=\"include/javascript/".$row.".js\"></SCRIPT>\n");
			}
		}
	}
	print("</HEAD>\n\n<BODY>\n");

	if($session->logged_in) {
		security_header();
		return TRUE;
	} else {
		login_script();
		return FALSE;
	}
}


?>